﻿using Microsoft.TeamFoundation.WorkItemTracking.WebApi;
using Microsoft.VisualStudio.Services.Common;
using System;
using System.Text;

namespace GetWorkitemById
{
    internal class Program
    {
        private static void Main(string[] args)
        {
            Console.CancelKeyPress += OnCancel;
            Console.WriteLine("This program gets the details of the work item given using TFS REST API");
            Console.WriteLine("Press Control + C anytime to quit");
            Console.WriteLine();
            Console.WriteLine("Please enter the TFS server url including the collection name.");
            Console.WriteLine("NOTE: Ensure that you have enterd https URL to TFS. This is necessary for connecting to TFS using username and password.");
            Console.WriteLine("E.g: https://tfs2015/tfs/defaultcollection");
            var tfsServerUrl = Console.ReadLine();
            Console.WriteLine("Please enter the username to connect");
            var userName = Console.ReadLine();
            Console.WriteLine("Please enter password");
            var password = GetConsolePassword();
            Console.WriteLine("Please enter the workitem id");
            var workitemId = Console.ReadLine();

            Console.WriteLine();
            Console.Write("Please wait...");

            WorkItemTrackingHttpClient witClient =
                new WorkItemTrackingHttpClient(new Uri(tfsServerUrl),
                    new VssBasicCredential(userName, password));
            var workItem = witClient.GetWorkItemAsync(Convert.ToInt32(workitemId)).Result;

            Console.WriteLine("Done!");

            Console.WriteLine($"***Details of WorkItem: {workitemId} ***");
            Console.WriteLine();
            Console.WriteLine($"Team Project: {workItem.Fields["System.TeamProject"]}");
            Console.WriteLine($"Type: {workItem.Fields["System.WorkItemType"]}");
            Console.WriteLine($"Title: {workItem.Fields["System.Title"]}");
            Console.WriteLine($"State: {workItem.Fields["System.State"]}");
            Console.WriteLine($"Created By: {workItem.Fields["System.CreatedBy"]}");

            Console.WriteLine();
            Console.WriteLine("Press any key to exit");
            Console.ReadLine();
        }

        private static void OnCancel(object sender, ConsoleCancelEventArgs args)
        {
            Console.WriteLine("Operation terminated...Press any key to exit.");
            args.Cancel = true;
        }

        private static string GetConsolePassword()
        {
            StringBuilder sb = new StringBuilder();
            while (true)
            {
                ConsoleKeyInfo cki = Console.ReadKey(true);
                if (cki.Key == ConsoleKey.Enter)
                {
                    Console.WriteLine();
                    break;
                }

                if (cki.Key == ConsoleKey.Backspace)
                {
                    if (sb.Length > 0)
                    {
                        Console.Write("\b\0\b");
                        sb.Length--;
                    }
                    continue;
                }
                Console.Write("*");
                sb.Append(cki.KeyChar);
            }
            return sb.ToString();
        }
    }
}